<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Aktivitas Harian
    </h2>
    <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/activities/store') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="tanggal" class="form-label">Tanggal <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="tanggal" name="tanggal" 
                       value="<?= old('tanggal', date('Y-m-d')) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="jam" class="form-label">Jam <span class="text-danger">*</span></label>
                <input type="time" class="form-control" id="jam" name="jam" 
                       value="<?= old('jam', date('H:i')) ?>" required>
            </div>
        </div>

        <div class="mb-3">
            <label for="nama_aktivitas" class="form-label">Nama Aktivitas <span class="text-danger">*</span></label>
            <input type="text" class="form-control" id="nama_aktivitas" name="nama_aktivitas" 
                   value="<?= old('nama_aktivitas') ?>" required>
        </div>

        <div class="mb-3 position-relative">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi aktivitas..."><?= old('deskripsi') ?></textarea>
            

        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="foto" class="form-label">Foto</label>
                <input type="file" class="form-control" id="foto" name="foto" 
                       accept="image/jpeg,image/png,image/gif">
                <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB)</small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="video" class="form-label">Video</label>
                <input type="file" class="form-control" id="video" name="video" 
                       accept="video/mp4,video/avi,video/mov">
                <small class="text-white">Format: MP4, AVI, MOV (Max: 10MB)</small>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>



